<?php
/**
 * Cierre de sesión del sistema
 */

// Incluir archivos de configuración y funciones
require_once 'includes/config.php';
require_once 'includes/functions.php';

// Iniciar sesión
session_start();

// Registrar actividad de cierre de sesión si hay un usuario autenticado
if (isset($_SESSION['user_id'])) {
    try {
        $conn = new PDO("mysql:host=$db_host;dbname=$db_name", $db_user, $db_pass);
        $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        
        registrarActividad($conn, $_SESSION['user_id'], 'logout', 'Cierre de sesión');
    } catch (PDOException $e) {
        // Error al registrar actividad, pero continuamos con el cierre de sesión
    }
}

// Destruir todas las variables de sesión
$_SESSION = array();

// Si se desea destruir la cookie de sesión
if (ini_get("session.use_cookies")) {
    $params = session_get_cookie_params();
    setcookie(session_name(), '', time() - 42000,
        $params["path"], $params["domain"],
        $params["secure"], $params["httponly"]
    );
}

// Finalmente, destruir la sesión
session_destroy();

// Redirigir al login
header('Location: login.php');
exit;