<?php
/**
 * Script para ejecutar la actualización de stock y EAN desde una URL
 * 
 * Modo de uso: https://santavictoria.cl/sisrendiciones/ejecutar.php?1234
 * 
 * También admite parámetros adicionales:
 * - ?clave=1234&detail=1 : Muestra información detallada del proceso
 * - ?clave=1234&format=json : Devuelve la respuesta en formato JSON
 */

// Aumentar el tiempo máximo de ejecución a 5 minutos
set_time_limit(300);

// Mostrar todos los errores para diagnóstico
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Clave de acceso
$clave_secreta = "1234";

// Verificar clave en formato simplificado (ej: ?1234)
$clave_proporcionada = $_SERVER['QUERY_STRING'];

// También verificar formato estándar (ej: ?clave=1234)
if (isset($_GET['clave'])) {
    $clave_proporcionada = $_GET['clave'];
}

// Determinar si se solicitó formato JSON
$format = isset($_GET['format']) ? strtolower($_GET['format']) : 'text';
$show_detail = isset($_GET['detail']) && $_GET['detail'] == '1';

if ($clave_proporcionada === $clave_secreta || (isset($_GET['clave']) && $_GET['clave'] === $clave_secreta)) {
    // Capturar la salida del script
    ob_start();
    
    // Variables para estadísticas
    $total_repuestos = 0;
    $actualizados_stock = 0;
    $actualizados_ean = 0;
    $actualizados_ambos = 0;
    $sin_cambios = 0;
    $errores = 0;
    $ean_encontrados = 0;
    $ean_no_encontrados = 0;
    
    // Registrar tiempo de inicio
    $tiempo_inicio = microtime(true);
    
    echo "=== EJECUCIÓN DE ACTUALIZACIÓN DE STOCK Y EAN ===\n\n";
    echo "Acceso autorizado. Iniciando actualización de stock y códigos EAN...\n\n";
    
    // Variables globales para capturar estadísticas
    global $STATS_total_repuestos, $STATS_actualizados_stock, $STATS_actualizados_ean, 
           $STATS_actualizados_ambos, $STATS_sin_cambios, $STATS_errores,
           $STATS_ean_encontrados, $STATS_ean_no_encontrados;
    
    // Inicializar variables globales
    $STATS_total_repuestos = 0;
    $STATS_actualizados_stock = 0;
    $STATS_actualizados_ean = 0;
    $STATS_actualizados_ambos = 0;
    $STATS_sin_cambios = 0;
    $STATS_errores = 0;
    $STATS_ean_encontrados = 0;
    $STATS_ean_no_encontrados = 0;
    
    // Función para capturar estadísticas de EAN
    function registerEANStats($found) {
        global $STATS_ean_encontrados, $STATS_ean_no_encontrados;
        if ($found) {
            $STATS_ean_encontrados++;
        } else {
            $STATS_ean_no_encontrados++;
        }
    }
    
    // Incluir el script actualizado
    include 'actualizar_stock.php';
    
    // Obtener estadísticas si están disponibles
    $total_repuestos = $STATS_total_repuestos ?: $total_repuestos;
    $actualizados_stock = $STATS_actualizados_stock ?: $actualizados_stock;
    $actualizados_ean = $STATS_actualizados_ean ?: $actualizados_ean;
    $actualizados_ambos = $STATS_actualizados_ambos ?: $actualizados_ambos;
    $sin_cambios = $STATS_sin_cambios ?: $sin_cambios;
    $errores = $STATS_errores ?: $errores;
    $ean_encontrados = $STATS_ean_encontrados ?: $ean_encontrados;
    $ean_no_encontrados = $STATS_ean_no_encontrados ?: $ean_no_encontrados;
    
    // Calcular tiempo de ejecución
    $tiempo_fin = microtime(true);
    $tiempo_ejecucion = round($tiempo_fin - $tiempo_inicio, 2);
    
    echo "\n=== RESUMEN DEL PROCESO ===\n";
    echo "Tiempo de ejecución: $tiempo_ejecucion segundos\n";
    echo "Total de repuestos procesados: $total_repuestos\n";
    echo "Repuestos con stock actualizado: $actualizados_stock\n";
    echo "Repuestos con EAN actualizado: $actualizados_ean\n";
    echo "Repuestos con ambos valores actualizados: $actualizados_ambos\n";
    echo "Total de EANs encontrados: $ean_encontrados\n";
    echo "Total de EANs no encontrados: $ean_no_encontrados\n";
    echo "Repuestos sin cambios: $sin_cambios\n";
    echo "Errores encontrados: $errores\n";
    
    echo "\n=== PROCESO COMPLETADO ===\n";
    
    // Capturar toda la salida
    $output = ob_get_clean();
    
    // Preparar la respuesta según el formato solicitado
    if ($format === 'json') {
        // Cabecera para JSON
        header('Content-Type: application/json');
        header('Cache-Control: no-store, no-cache, must-revalidate');
        
        // Crear respuesta JSON
        $response = [
            'success' => true,
            'tiempo_ejecucion' => $tiempo_ejecucion,
            'estadisticas' => [
                'total_repuestos' => $total_repuestos,
                'actualizados_stock' => $actualizados_stock,
                'actualizados_ean' => $actualizados_ean,
                'actualizados_ambos' => $actualizados_ambos,
                'ean_encontrados' => $ean_encontrados,
                'ean_no_encontrados' => $ean_no_encontrados,
                'sin_cambios' => $sin_cambios,
                'errores' => $errores
            ],
            'detalles' => $show_detail ? $output : null
        ];
        
        echo json_encode($response, JSON_PRETTY_PRINT);
    } else {
        // Respuesta en texto plano
        header('Content-Type: text/plain');
        header('Cache-Control: no-store, no-cache, must-revalidate');
        
        echo $output;
    }
} else {
    // Si la clave es incorrecta, denegar el acceso
    header('HTTP/1.1 403 Forbidden');
    
    if ($format === 'json') {
        header('Content-Type: application/json');
        echo json_encode(['success' => false, 'error' => 'Acceso denegado: Clave incorrecta']);
    } else {
        echo "Acceso denegado: Clave incorrecta";
    }
}
?>