<?php
/**
 * Script para actualizar stock y códigos de barras desde Softland
 * Este script puede ejecutarse desde una URL o programarse como tarea cron
 * 
 * Modo de uso:
 * - Desde navegador: https://santavictoria.cl/sisrendiciones/actualizar_stock.php?clave=su_clave_secreta
 * - Desde cron: php /ruta/al/sitio/actualizar_stock.php clave=su_clave_secreta
 */

// Configuración básica
$clave_secreta = "11223344"; // Cambiar por una clave segura

// Verificar si se ejecuta desde línea de comandos o desde navegador
$desde_cli = (php_sapi_name() == 'cli');
$clave_proporcionada = '';

if ($desde_cli) {
    // Obtener clave desde argumentos de línea de comandos
    foreach ($argv as $arg) {
        if (strpos($arg, 'clave=') === 0) {
            $clave_proporcionada = substr($arg, 6);
        }
    }
    // Salida en modo texto plano
    header('Content-Type: text/plain');
} else {
    // Obtener clave desde GET
    $clave_proporcionada = $_GET['clave'] ?? '';
    
    // Detectar formato de respuesta deseado
    $format = isset($_GET['format']) ? strtolower($_GET['format']) : 'text';
    if ($format == 'json') {
        header('Content-Type: application/json');
    } else {
        header('Content-Type: text/plain');
    }
}

// Verificar clave
if ($clave_proporcionada !== $clave_secreta) {
    if ($format == 'json') {
        echo json_encode(['success' => false, 'error' => 'Clave de acceso incorrecta']);
    } else {
        echo "ERROR: Clave de acceso incorrecta\n";
    }
    exit;
}

// Incluir el archivo de integración
require_once 'softland_integration.php';

// Ejecutar actualización
$tiempo_inicio = microtime(true);
$resultado = actualizarStockDesdeSOftland();
$tiempo_fin = microtime(true);
$tiempo_ejecucion = round($tiempo_fin - $tiempo_inicio, 2);

// Preparar respuesta
if (isset($format) && $format == 'json') {
    // Respuesta en formato JSON
    $respuesta = [
        'success' => $resultado['success'],
        'tiempo_ejecucion' => $tiempo_ejecucion,
        'timestamp' => date('Y-m-d H:i:s')
    ];
    
    if ($resultado['success']) {
        $respuesta['estadisticas'] = $resultado['estadisticas'];
    } else {
        $respuesta['error'] = $resultado['error'];
    }
    
    echo json_encode($respuesta, JSON_PRETTY_PRINT);
} else {
    // Respuesta en formato texto
    if ($resultado['success']) {
        echo "=== ACTUALIZACIÓN COMPLETADA ===\n";
        echo "Tiempo de ejecución: $tiempo_ejecucion segundos\n";
        echo "Fecha y hora: " . date('Y-m-d H:i:s') . "\n\n";
        
        echo "ESTADÍSTICAS:\n";
        echo "- Total repuestos procesados: " . $resultado['estadisticas']['total_repuestos'] . "\n";
        echo "- Stock actualizado: " . $resultado['estadisticas']['actualizados_stock'] . "\n";
        echo "- EAN actualizado: " . $resultado['estadisticas']['actualizados_ean'] . "\n";
        echo "- Ambos actualizados: " . $resultado['estadisticas']['actualizados_ambos'] . "\n";
        echo "- EAN encontrados: " . $resultado['estadisticas']['ean_encontrados'] . "\n";
        echo "- Sin cambios: " . $resultado['estadisticas']['sin_cambios'] . "\n";
        echo "- Errores: " . $resultado['estadisticas']['errores'] . "\n";
        
        echo "\nArchivo de log: " . $resultado['log_file'] . "\n";
    } else {
        echo "=== ERROR EN LA ACTUALIZACIÓN ===\n";
        echo "Error: " . $resultado['error'] . "\n";
        echo "Fecha y hora: " . date('Y-m-d H:i:s') . "\n";
        echo "Archivo de log: " . $resultado['log_file'] . "\n";
    }
}
?>