// Funciones generales para toda la aplicación

// Formatear números como moneda chilena
function formatoMoneda(valor) {
    return '$' + new Intl.NumberFormat('es-CL').format(valor);
}

// Validación de RUT chileno
function validaRut(rutCompleto) {
    if (!/^[0-9]+-[0-9kK]{1}$/.test(rutCompleto))
        return false;
    
    var tmp = rutCompleto.split('-');
    var rut = tmp[0];
    var dv = tmp[1].toLowerCase();
    
    // Cálculo del dígito verificador
    var suma = 0;
    var multiplo = 2;
    
    for (var i = rut.length - 1; i >= 0; i--) {
        suma += rut.charAt(i) * multiplo;
        multiplo = multiplo < 7 ? multiplo + 1 : 2;
    }
    
    var dvEsperado = 11 - (suma % 11);
    dvEsperado = dvEsperado == 11 ? '0' : dvEsperado == 10 ? 'k' : dvEsperado.toString();
    
    return dv === dvEsperado;
}

// Inicializar elementos cuando el DOM está listo
document.addEventListener('DOMContentLoaded', function() {
    // Inicializar eventos para inputs de monto
    var montoInputs = document.querySelectorAll('.monto-input');
    if (montoInputs.length > 0) {
        montoInputs.forEach(function(input) {
            input.addEventListener('input', function() {
                if (typeof calcularTotales === 'function') {
                    calcularTotales();
                }
            });
        });
    }
});