<?php
require_once 'includes/config.php';
require_once 'includes/functions.php';

header('Content-Type: application/json');

try {
    if (!isset($_GET['serie_id']) || empty($_GET['serie_id'])) {
        throw new Exception('No se proporcionó ID de serie');
    }

    $serie_id = $_GET['serie_id'];
    
    $conn = new PDO("mysql:host=$db_host;dbname=$db_name", $db_user, $db_pass);
    $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
    // Consulta para obtener la información del cliente solo si está asociado
    $query = "SELECT s.id as serie_id, s.codigo_serie, s.cliente_id, 
              c.nombre as cliente_nombre, c.rut as cliente_rut 
              FROM series_maquinas s 
              LEFT JOIN clientes c ON s.cliente_id = c.id 
              WHERE s.id = :serie_id AND s.activo = 1";
    
    $stmt = $conn->prepare($query);
    $stmt->execute(['serie_id' => $serie_id]);
    $result = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if ($result && $result['cliente_id'] !== null) {
        echo json_encode([
            'success' => true,
            'cliente' => [
                'nombre' => $result['cliente_nombre'],
                'rut' => $result['cliente_rut']
            ]
        ]);
    } else {
        echo json_encode([
            'success' => true,
            'cliente' => null
        ]);
    }
    
} catch (Exception $e) {
    echo json_encode([
        'success' => false,
        'message' => $e->getMessage()
    ]);
} 