<?php
/**
 * Busca un proveedor por su RUT
 * Devuelve la información en formato JSON
 */

// Incluir archivos de configuración y funciones
require_once 'includes/config.php';
require_once 'includes/functions.php';

// Verificar sesión
verificarSesion();

// Verificar que se haya enviado el RUT
if (!isset($_GET['rut']) || empty($_GET['rut'])) {
    echo json_encode(['success' => false, 'message' => 'RUT no proporcionado']);
    exit;
}

$rut = trim($_GET['rut']);

// Conexión a la base de datos
try {
    $conn = new PDO("mysql:host=$db_host;dbname=$db_name;charset=utf8mb4", $db_user, $db_pass, $db_options);
    $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
    // Buscar proveedor por RUT
    $stmt = $conn->prepare("SELECT * FROM proveedores WHERE rut = :rut AND activo = 1");
    $stmt->bindParam(':rut', $rut);
    $stmt->execute();
    
    $proveedor = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if ($proveedor) {
        echo json_encode([
            'success' => true,
            'proveedor' => $proveedor
        ]);
    } else {
        echo json_encode([
            'success' => false,
            'message' => 'No se encontró un proveedor activo con este RUT'
        ]);
    }
    
} catch (PDOException $e) {
    echo json_encode([
        'success' => false,
        'message' => 'Error en la base de datos: ' . $e->getMessage()
    ]);
}
?>